//
//  OPEnemy.m
//  The Obfuscated Path
//
//  Created by ss2cire on 1/4/09.
//  Copyright 2009 GryphonClaw Software. All rights reserved.
//

#import "OPEnemy.h"

@implementation OPEnemy
- (id)initWithLocation:(OPPoint)inLocation andSize:(OPSize)inSize
{
	self = [super initWithLocation:inLocation andSize:OPMakeSize(32, 32)];
	if(self != nil) {
		boss = NO;
		variation = 0;
		moveSpeed = (120 * UPDATE_INTERVAL);
		hits = 1;
		dead = NO;
	}
	return self;
}

- (void)setEnemyData:(NSDictionary *)data
{
}

- (void)kill
{
	//put code here for it to spawn an item and die
}

-(void)setNewDirectionExcluding:(OPDirection)theDirection
{
}

- (BOOL)hurt
{
	#define MIN_HIT_TIME 0.5
	if([NSDate timeIntervalSinceReferenceDate] - lastHitTime > MIN_HIT_TIME)
	{
		hit = YES;
		maxHealth -= 1;
		if(maxHealth <= 0) {
			[self kill];
			dead = YES;
		}
		lastHitTime = [NSDate timeIntervalSinceReferenceDate];
	} else {
		hit = NO;
	}
	return dead;
}

@end
